<?php
// /template/header.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    // Arahkan ke index.php di root, bukan login langsung
    header("location: index.php"); 
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Stress Sirna'; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&family=Fredoka+One&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css"/>
    <style>
        body, html { margin: 0; padding: 0; font-family: 'Poppins', sans-serif; background-color: #f4f7f9; }
        .navbar {
            background-color: #ffffff;
            padding: 0 50px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            position: relative;
        }
        .navbar .logo { display: flex; align-items: center; gap: 10px; padding: 15px 0; text-decoration:none; } 
        .navbar .logo img { height: 40px; } 
        .navbar .logo span { font-weight: 600; font-size: 1.2em; color: #2c3e50; }
        .nav-menu { list-style: none; display: flex; margin: 0; padding: 0; }
        .nav-menu li a { display: block; padding: 25px 20px; text-decoration: none; color: #555; font-weight: 500; transition: color 0.2s; }
        .nav-menu li a.active, .nav-menu li a:hover { color: #3498db; }
        
        .hamburger {
            display: none;
            font-size: 1.5rem;
            background: none;
            border: none;
            cursor: pointer;
            color: #2c3e50;
        }

        .main-container { padding: 40px; max-width: 1200px; margin: auto; }
        .card { background-color: #ffffff; border-radius: 15px; padding: 35px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); margin-bottom: 30px;}
        .card h1, .card h2 { margin-top: 0; text-align: center; color: #2c3e50; }

        /* KODE CSS RESPONSIF UNTUK HP */
        @media (max-width: 992px) {
            .navbar {
                padding: 0 20px;
            }
            .hamburger {
                display: block; /* Tampilkan tombol hamburger */
            }
            .nav-menu {
                display: none; /* Sembunyikan menu desktop */
                flex-direction: column;
                position: absolute;
                top: 100%;
                left: 0;
                width: 100%;
                background-color: #ffffff;
                box-shadow: 0 8px 16px rgba(0,0,0,0.1);
                border-top: 1px solid #f0f0f0;
                z-index: 100;
            }
            /* Style saat menu mobile aktif (dibuka) */
            .nav-menu.active {
                display: flex;
            }
            .nav-menu li a {
                padding: 15px 20px;
                border-bottom: 1px solid #f0f0f0;
            }
            .main-container {
                padding: 20px;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <a href="dashboard.php" class="logo">
            <img src="img/logo.png" alt="Logo">
            <span>Stress Sirna</span>
        </a>
        <button class="hamburger" id="hamburger-btn">
            <i class="fas fa-bars"></i>
        </button>
        <ul class="nav-menu" id="nav-menu">
            <li><a href="dashboard.php" class="<?php if($current_page == 'dashboard') echo 'active'; ?>">Dashboard</a></li>
            <li><a href="kuesioner.php" class="<?php if($current_page == 'kuesioner') echo 'active'; ?>">Deteksi Dini</a></li>
            <li><a href="intervensi.php" class="<?php if($current_page == 'intervensi') echo 'active'; ?>">Intervensi</a></li>
            <li><a href="informasi.php" class="<?php if($current_page == 'informasi') echo 'active'; ?>">Informasi</a></li>
            <li><a href="profil.php" class="<?php if($current_page == 'profil') echo 'active'; ?>">Profil</a></li>
            <li><a href="logout.php">Logout</a></li>
        </ul>
    </nav>