<?php
// Tentukan halaman saat ini dan judulnya untuk template
$current_page = 'dashboard'; // Kita anggap ini bagian dari menu Dashboard
$page_title = 'Riwayat Tes - Stress Sirna';

// Panggil template header
require_once 'template/header.php';

// --- Mulai PHP Logic khusus untuk halaman ini ---
$conn = new mysqli("localhost", "root", "", "stress_sirna_db");
$user_id = $_SESSION['userid'];

// Ambil semua riwayat tes untuk pengguna yang sedang login
$history = $conn->query("
    SELECT 
        score, 
        status, 
        pendidikan, 
        lama_bekerja,
        DATE_FORMAT(test_date, '%d %M %Y - %H:%i') as formatted_date 
    FROM test_history 
    WHERE user_id = $user_id 
    ORDER BY test_date DESC
");
$conn->close();
?>

<style>
    /* CSS khusus untuk halaman ini */
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    th, td {
        padding: 12px 15px;
        border: 1px solid #e2e8f0;
        text-align: left;
        vertical-align: middle;
    }
    th {
        background-color: #f8fafc;
        font-weight: 600;
        color: #475569;
    }
    td {
        color: #334155;
    }
    .btn-back {
        display: inline-block;
        margin-bottom: 20px;
        background-color: #6c757d;
        color: white;
        padding: 10px 20px;
        text-decoration: none;
        border-radius: 5px;
        font-weight: 500;
    }
</style>

<div class="main-container">
    <div class="card">
        <a href="dashboard.php" class="btn-back"><i class="fas fa-arrow-left"></i> Kembali ke Dashboard</a>
        <h1 style="text-align:left;">Riwayat Tes Lengkap</h1>
        
        <div style="overflow-x:auto;">
            <table>
                <thead>
                    <tr>
                        <th>Tanggal Tes</th>
                        <th>Skor</th>
                        <th>Status</th>
                        <th>Pendidikan</th>
                        <th>Lama Bekerja</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($history->num_rows > 0): ?>
                        <?php while($row = $history->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo $row['formatted_date']; ?></td>
                            <td><?php echo $row['score']; ?></td>
                            <td><?php echo htmlspecialchars($row['status']); ?></td>
                            <td><?php echo htmlspecialchars($row['pendidikan']); ?></td>
                            <td><?php echo htmlspecialchars($row['lama_bekerja']); ?></td>
                        </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" style="text-align:center;">Anda belum memiliki riwayat tes.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
// Panggil template footer
require_once 'template/footer.php';
?>