<?php
// reset_password.php
$message = '';
$message_type = '';
$token_is_valid = false;

$servername = "localhost"; $db_username = "root"; $db_password = ""; $dbname = "stress_sirna_db";
$conn = new mysqli($servername, $db_username, $db_password, $dbname);

// Cek validitas token dari URL
if (isset($_GET['token'])) {
    $token = $_GET['token'];
    
    $stmt = $conn->prepare("SELECT id FROM users WHERE reset_token = ? AND reset_token_expires_at > NOW()");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $token_is_valid = true;
    } else {
        $message = "Error: Link reset tidak valid atau sudah kedaluwarsa.";
        $message_type = 'error';
    }
    $stmt->close();
}

// Proses form jika password baru di-submit
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['token'])) {
    $token = $_POST['token'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    if ($new_password !== $confirm_password) {
        $message = "Error: Konfirmasi password tidak cocok.";
        $message_type = 'error';
        $token_is_valid = true; // Tetap tampilkan form
    } else {
        // Hash password baru
        $new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        
        // Update password dan hapus token
        $stmt = $conn->prepare("UPDATE users SET password = ?, reset_token = NULL, reset_token_expires_at = NULL WHERE reset_token = ?");
        $stmt->bind_param("ss", $new_hashed_password, $token);
        
        if ($stmt->execute()) {
            $message = "Password Anda telah berhasil direset! Silakan login dengan password baru Anda.";
            $message_type = 'success';
            $token_is_valid = false; // Sembunyikan form setelah sukses
        } else {
            $message = "Terjadi kesalahan saat mereset password.";
            $message_type = 'error';
            $token_is_valid = true;
        }
        $stmt->close();
    }
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Reset Password - Stress Sirna</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f4f7f9; display: flex; justify-content: center; align-items: center; height: 100vh; }
        .container { background-color: #fff; padding: 40px; border-radius: 10px; box-shadow: 0 5px 15px rgba(0,0,0,0.1); width: 400px; text-align: center; }
        h2 { margin-top: 0; }
        .form-group { margin-bottom: 20px; text-align: left; }
        label { display: block; margin-bottom: 5px; }
        input[type="password"] { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; box-sizing: border-box; }
        .btn { width: 100%; padding: 12px; background-color: #28a745; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 1em; }
        .message { padding: 15px; border-radius: 5px; margin-bottom: 20px; word-wrap: break-word; }
        .message.success { background-color: #d4edda; color: #155724; }
        .message.error { background-color: #f8d7da; color: #721c24; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Reset Password Baru</h2>
        
        <?php if ($token_is_valid): ?>
            <p>Masukkan password baru Anda di bawah ini.</p>
            <form action="reset_password.php" method="POST">
                <input type="hidden" name="token" value="<?php echo htmlspecialchars($_GET['token']); ?>">
                <div class="form-group">
                    <label for="new_password">Password Baru</label>
                    <input type="password" name="new_password" required>
                </div>
                <div class="form-group">
                    <label for="confirm_password">Konfirmasi Password Baru</label>
                    <input type="password" name="confirm_password" required>
                </div>
                <button type="submit" class="btn">Reset Password</button>
            </form>
        <?php endif; ?>

        <?php if(!empty($message)) echo '<div class="message '.$message_type.'">'.$message.'</div>'; ?>
        
        <?php if($message_type === 'success'): ?>
             <p style="margin-top: 20px;"><a href="login.php">Lanjutkan ke Halaman Login</a></p>
        <?php endif; ?>
    </div>
</body>
</html>