<?php
// Tentukan halaman saat ini dan judulnya untuk template
$current_page = 'informasi'; // Kita anggap ini bagian dari menu Informasi
$page_title = 'Panduan Relaksasi - Stress Sirna';

// Panggil template header. Ini akan otomatis memulai session dan menampilkan navbar.
require_once 'template/header.php';

// Ambil konten dari database
$conn = new mysqli("localhost", "root", "", "stress_sirna_db");
$contents_raw = $conn->query("SELECT content_key, content_value FROM site_content WHERE content_group = 'relaksasi'");
$content = [];
while($row = $contents_raw->fetch_assoc()) { $content[$row['content_key']] = $row['content_value']; }
$conn->close();
?>

<style>
    /* CSS khusus untuk halaman ini */
    .steps-list { 
        list-style: none; 
        padding: 0; 
        margin-top: 30px; 
    }
    .steps-item { 
        display: flex; 
        align-items: flex-start; 
        gap: 20px; 
        margin-bottom: 25px; 
    }
    .steps-item .icon { 
        font-size: 1.8em; 
        color: #3498db; 
        flex-shrink: 0; 
        width: 50px; 
        height: 50px; 
        background-color: #ecf0f1; 
        border-radius: 50%; 
        display: flex; 
        justify-content: center; 
        align-items: center;
    }
    .steps-item h3 { 
        margin: 0 0 5px 0; 
        font-size: 1.2em; 
    }
    .steps-item p { 
        margin: 0; 
        color: #555; 
    }
</style>

<div class="main-container">
    <div class="card">
        <h1><?php echo $content['relaksasi_title'] ?? 'Judul Relaksasi'; ?></h1>
        <p style="text-align: center; color: #555; max-width: 700px; margin: auto;">
            <?php echo $content['relaksasi_intro'] ?? 'Intro...'; ?>
        </p>
        <ul class="steps-list">
            <li class="steps-item">
                <span class="icon">1</span>
                <div>
                    <h3><?php echo $content['relaksasi_step1_title']; ?></h3>
                    <p><?php echo $content['relaksasi_step1_desc']; ?></p>
                </div>
            </li>
            <li class="steps-item">
                <span class="icon">2</span>
                <div>
                    <h3><?php echo $content['relaksasi_step2_title']; ?></h3>
                    <p><?php echo $content['relaksasi_step2_desc']; ?></p>
                </div>
            </li>
            <li class="steps-item">
                <span class="icon">3</span>
                <div>
                    <h3><?php echo $content['relaksasi_step3_title']; ?></h3>
                    <p><?php echo $content['relaksasi_step3_desc']; ?></p>
                </div>
            </li>
            <li class="steps-item">
                <span class="icon">4</span>
                <div>
                    <h3><?php echo $content['relaksasi_step4_title']; ?></h3>
                    <p><?php echo $content['relaksasi_step4_desc']; ?></p>
                </div>
            </li>
        </ul>
    </div>
</div>

<?php
// Panggil template footer untuk menutup halaman
require_once 'template/footer.php';
?>