<?php
$message = ''; 
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $servername = "localhost";
    $db_username = "root";
    $db_password = "";
    $dbname = "stress_sirna_db";
    $conn = new mysqli($servername, $db_username, $db_password, $dbname);
    if ($conn->connect_error) { die("Koneksi gagal: " . $conn->connect_error); }
    $username = $_POST['username'];
    $email = $_POST['email'];
    $password = $_POST['password'];
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $conn->prepare("INSERT INTO users (username, email, password) VALUES (?, ?, ?)");
    $stmt->bind_param("sss", $username, $email, $hashed_password);
    if ($stmt->execute()) {
        $message = "Registrasi berhasil! Silakan login.";
    } else {
        if ($conn->errno == 1062) {
            $message = "Error: Username atau Email sudah terdaftar.";
        } else {
            $message = "Error: " . $stmt->error;
        }
    }
    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registrasi - Stress Sirna</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* CSS ini disamakan dengan halaman login.php untuk konsistensi */
        body, html {
            margin: 0;
            padding: 0;
            height: 100%;
            font-family: 'Poppins', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            /* Latar belakang gradien yang sama */
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .register-container {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            width: 350px;
            max-width: 90%;
            text-align: center;
        }
        .logo { max-width: 80px; margin-bottom: 10px; }
        h1 { font-size: 1.8em; color: #2c3e50; margin: 0; }
        .tagline { color: #7f8c8d; margin-bottom: 30px; font-size: 0.9em; }
        .form-group { margin-bottom: 20px; text-align: left; }
        input[type="text"], input[type="email"], input[type="password"] {
            width: 100%;
            padding: 12px 0;
            border: none;
            border-bottom: 2px solid #bdc3c7;
            background-color: transparent;
            font-size: 1em;
            font-family: 'Poppins', sans-serif;
            transition: border-color 0.3s;
        }
        input[type="text"]:focus, input[type="email"]:focus, input[type="password"]:focus {
            outline: none;
            border-bottom-color: #3498db;
        }
        .btn {
            display: block;
            width: 100%;
            padding: 15px;
            border-radius: 25px;
            font-size: 1.1em;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            transition: all 0.3s;
            margin-top: 30px;
            margin-bottom: 15px;
            box-sizing: border-box;
        }
        .btn-primary {
            background-color: #3498db;
            color: white;
            border: none;
        }
        .btn-primary:hover {
            background-color: #2980b9;
        }
        .login-link { font-size: 0.9em; color: #555; }
        .login-link a { color: #3498db; text-decoration: none; font-weight: 600; }
        .message {
            margin-bottom: 15px;
            font-weight: 500;
            padding: 10px;
            border-radius: 5px;
        }
        .message.success { color: #27ae60; background-color: #d4edda; }
        .message.error { color: #e74c3c; background-color: #f8d7da; }
    </style>
</head>
<body>
    <div class="register-container">
        <img src="img/logo.png" alt="Stress Sirna Logo" class="logo">
        <h1>BUAT AKUN</h1>
        <p class="tagline">Isi data diri untuk memulai perjalanan Anda</p>

        <?php if (!empty($message)): ?>
            <p class="message <?php echo (strpos($message, 'berhasil') !== false) ? 'success' : 'error'; ?>">
                <?php echo $message; ?>
            </p>
        <?php endif; ?>

        <form action="register.php" method="POST">
            <div class="form-group">
                <input type="text" name="username" placeholder="Username" required>
            </div>
            <div class="form-group">
                <input type="email" name="email" placeholder="Email" required>
            </div>
            <div class="form-group">
                <input type="password" name="password" placeholder="Password" required>
            </div>
            
            <button type="submit" class="btn btn-primary">REGISTRASI</button>
        </form>

        <p class="login-link">Sudah punya akun? <a href="login.php">Login di sini</a></p>
    </div>
</body>
</html>