<?php
// Tentukan halaman saat ini dan judulnya untuk template
$current_page = 'profil';
$page_title = 'Profil Saya - Stress Sirna';

// Panggil template header. Ini akan otomatis memulai session dan menampilkan navbar.
require_once 'template/header.php';

// --- Mulai PHP Logic khusus untuk halaman ini ---
$servername = "localhost"; $db_username = "root"; $db_password = ""; $dbname = "stress_sirna_db";
$conn = new mysqli($servername, $db_username, $db_password, $dbname);

$user_id = $_SESSION['userid'];
$message = '';
$message_type = ''; // 'success' or 'error'

// --- BAGIAN 1: Mengambil Data Pengguna & Demografi ---
$user_data = [];
$demographics = ['pendidikan' => 'Belum ada data', 'lama_bekerja' => 'Belum ada data'];

if (!$conn->connect_error) {
    // Ambil data dari tabel 'users'
    $stmt_user = $conn->prepare("SELECT username, email, created_at FROM users WHERE id = ?");
    $stmt_user->bind_param("i", $user_id);
    $stmt_user->execute();
    $result_user = $stmt_user->get_result();
    $user_data = $result_user->fetch_assoc();
    $stmt_user->close();

    // Ambil data demografi terakhir dari 'test_history'
    $stmt_demo = $conn->prepare("SELECT pendidikan, lama_bekerja FROM test_history WHERE user_id = ? ORDER BY test_date DESC LIMIT 1");
    $stmt_demo->bind_param("i", $user_id);
    $stmt_demo->execute();
    $result_demo = $stmt_demo->get_result();
    if ($result_demo->num_rows > 0) {
        $demographics = $result_demo->fetch_assoc();
    }
    $stmt_demo->close();
}

// --- BAGIAN 2: Memproses Form Ubah Password ---
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $old_password = $_POST['old_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    if (empty($old_password) || empty($new_password) || empty($confirm_password)) {
        $message = "Error: Semua kolom password harus diisi.";
        $message_type = 'error';
    } elseif ($new_password !== $confirm_password) {
        $message = "Error: Konfirmasi password baru tidak cocok.";
        $message_type = 'error';
    } else {
        // Buat koneksi baru khusus untuk proses update, karena koneksi sebelumnya mungkin sudah ditutup
        $conn_update = new mysqli($servername, $db_username, $db_password, $dbname);
        
        // Ambil password saat ini dari DB untuk verifikasi
        $stmt_pass = $conn_update->prepare("SELECT password FROM users WHERE id = ?");
        $stmt_pass->bind_param("i", $user_id);
        $stmt_pass->execute();
        $result_pass = $stmt_pass->get_result();
        $user = $result_pass->fetch_assoc();
        $hashed_password = $user['password'];
        $stmt_pass->close();

        // Verifikasi password lama
        if (password_verify($old_password, $hashed_password)) {
            // Jika benar, hash password baru dan update ke DB
            $new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $stmt_update = $conn_update->prepare("UPDATE users SET password = ? WHERE id = ?");
            $stmt_update->bind_param("si", $new_hashed_password, $user_id);
            if ($stmt_update->execute()) {
                $message = "Password berhasil diperbarui!";
                $message_type = 'success';
            } else {
                $message = "Error: Gagal memperbarui password.";
                $message_type = 'error';
            }
            $stmt_update->close();
        } else {
            $message = "Error: Password lama yang Anda masukkan salah.";
            $message_type = 'error';
        }
        $conn_update->close();
    }
}
$conn->close(); // Tutup koneksi awal
?>

<style>
    /* CSS khusus untuk halaman profil */
    .card h2 { margin: 0 0 20px 0; padding-bottom: 15px; border-bottom: 1px solid #eee; }
    .info-grid { display: grid; grid-template-columns: 150px 1fr; gap: 10px; }
    .info-grid dt { font-weight: 600; color: #555; }
    .info-grid dd { margin: 0; color: #333; }
    .form-group { margin-bottom: 15px; }
    .form-group label { display: block; font-weight: 500; margin-bottom: 5px; }
    .form-group input { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px; box-sizing: border-box; }
    .btn { padding: 12px 25px; border-radius: 5px; text-decoration: none; border: none; cursor: pointer; font-weight: 600; }
    .btn-primary { background-color: #3498db; color: white; }
    .message { padding: 15px; border-radius: 5px; margin-bottom: 20px; }
    .message.success { background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
    .message.error { background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
</style>

<div class="main-container">
    <?php if ($message): ?>
        <div class="message <?php echo $message_type; ?>"><?php echo $message; ?></div>
    <?php endif; ?>

    <div class="card">
        <h2>Informasi Akun</h2>
        <dl class="info-grid">
            <dt>Username</dt>
            <dd><?php echo htmlspecialchars($user_data['username']); ?></dd>
            <dt>Email</dt>
            <dd><?php echo htmlspecialchars($user_data['email']); ?></dd>
            <dt>Bergabung Sejak</dt>
            <dd><?php echo date("d F Y", strtotime($user_data['created_at'])); ?></dd>
        </dl>
    </div>

    <div class="card">
        <h2>Data Kuesioner Terakhir</h2>
        <dl class="info-grid">
            <dt>Pendidikan</dt>
            <dd><?php echo htmlspecialchars($demographics['pendidikan']); ?></dd>
            <dt>Lama Bekerja</dt>
            <dd><?php echo htmlspecialchars($demographics['lama_bekerja']); ?></dd>
        </dl>
    </div>

    <div class="card">
        <h2>Ubah Password</h2>
        <form action="profil.php" method="POST">
            <div class="form-group">
                <label for="old_password">Password Lama</label>
                <input type="password" id="old_password" name="old_password" required>
            </div>
            <div class="form-group">
                <label for="new_password">Password Baru</label>
                <input type="password" id="new_password" name="new_password" required>
            </div>
            <div class="form-group">
                <label for="confirm_password">Konfirmasi Password Baru</label>
                <input type="password" id="confirm_password" name="confirm_password" required>
            </div>
            <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
        </form>
    </div>
</div>

<?php
// Panggil template footer untuk menutup halaman
require_once 'template/footer.php';
?>