<?php
session_start();
// Jika pengguna sudah login, langsung arahkan ke dasbor
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header("Location: dashboard.php");
    exit;
}

$message = '';
// Logika PHP untuk memproses form login
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $servername = "localhost";
    $db_username = "root";
    $db_password = "";
    $dbname = "stress_sirna_db";
    $conn = new mysqli($servername, $db_username, $db_password, $dbname);

    if ($conn->connect_error) {
        die("Koneksi gagal: " . $conn->connect_error);
    }

    $email = $_POST['email'];
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT id, username, password FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        $user = $result->fetch_assoc();
        if (password_verify($password, $user['password'])) {
            // Jika password cocok, login berhasil
            $_SESSION['loggedin'] = true;
            $_SESSION['userid'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            header("Location: dashboard.php");
            exit;
        } else {
            $message = "Email atau password yang Anda masukkan salah.";
        }
    } else {
        $message = "Email atau password yang Anda masukkan salah.";
    }
    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Stress Sirna</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body, html {
            margin: 0;
            padding: 0;
            height: 100%;
            font-family: 'Poppins', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            /* Latar belakang gradien */
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .login-container {
            background-color: #ffffff;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            width: 350px;
            max-width: 90%;
            text-align: center;
        }
        .logo { max-width: 80px; margin-bottom: 10px; }
        h1 { font-size: 1.8em; color: #2c3e50; margin: 0; }
        .tagline { color: #7f8c8d; margin-bottom: 30px; font-size: 0.9em; }
        .form-group { margin-bottom: 20px; text-align: left; }
        input[type="email"], input[type="password"] {
            width: 100%;
            padding: 12px 0;
            border: none;
            border-bottom: 2px solid #bdc3c7;
            background-color: transparent;
            font-size: 1em;
            font-family: 'Poppins', sans-serif;
            transition: border-color 0.3s;
        }
        input[type="email"]:focus, input[type="password"]:focus {
            outline: none;
            border-bottom-color: #3498db;
        }
        .options {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 0.9em;
            color: #555;
            margin-bottom: 30px;
        }
        .options label { display: flex; align-items: center; }
        .options a { color: #3498db; text-decoration: none; }
        .btn {
            display: block;
            width: 100%;
            padding: 15px;
            border-radius: 25px;
            font-size: 1.1em;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            transition: all 0.3s;
            margin-bottom: 15px;
            box-sizing: border-box;
        }
        .btn-login { background-color: #3498db; color: white; border: none; }
        .btn-login:hover { background-color: #2980b9; }
        .btn-register { background-color: transparent; color: #3498db; border: 2px solid #3498db; }
        .btn-register:hover { background-color: #3498db; color: white; }
        .message { color: #e74c3c; margin-bottom: 15px; font-weight: 500; }
    </style>
</head>
<body>
    <div class="login-container">
        <img src="img/logo.png" alt="Stress Sirna Logo" class="logo">
        <h1>STRESS SIRNA</h1>
        <p class="tagline">MENCEGAH BURNOUT, MERAWAT SENYUM</p>

        <?php if (!empty($message)): ?>
            <p class="message"><?php echo $message; ?></p>
        <?php endif; ?>

        <form action="login.php" method="POST">
            <div class="form-group">
                <input type="email" name="email" placeholder="Email / Username" required>
            </div>
            <div class="form-group">
                <input type="password" name="password" placeholder="Password" required>
            </div>
            <div class="options">
                <label>
                    <input type="checkbox" name="remember"> Ingat Saya
                </label>
                <a href="forgot_password.php">Lupa Password?</a>
            </div>
            <button type="submit" class="btn btn-login">LOGIN</button>
            <a href="register.php" class="btn btn-register">REGISTRASI</a>
        </form>
    </div>
</body>
</html>