<?php
// Tentukan halaman saat ini dan judulnya untuk template
$current_page = 'kuesioner';
$page_title = 'Kuesioner - Stress Sirna';

// Panggil template header, ini akan otomatis memulai session dan menampilkan navbar.
require_once 'template/header.php';

// --- Mulai PHP Logic khusus untuk halaman ini ---
$servername = "localhost"; $db_username = "root"; $db_password = ""; $dbname = "stress_sirna_db";
$conn = new mysqli($servername, $db_username, $db_password, $dbname);

$error_message = '';

// Kode untuk memproses form
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $pendidikan = $_POST['pendidikan'] ?? 'Tidak diisi';
    $lama_bekerja = $_POST['lama_bekerja'] ?? 'Tidak diisi';
    
    // Pastikan semua 30 pertanyaan dijawab
    if (isset($_POST['answers']) && count($_POST['answers']) === 30) {
        $answers = $_POST['answers'];
        $total_score = array_sum($answers);
        $status = 'Berat';
        if ($total_score <= 60) { $status = 'Rendah'; } 
        elseif ($total_score <= 90) { $status = 'Sedang'; }
        
        $user_id = $_SESSION['userid'];
        // (Logika simpan ke database tidak berubah)
        $stmt_update = $conn->prepare("UPDATE users SET burnout_score = ?, burnout_status = ? WHERE id = ?");
        $stmt_update->bind_param("isi", $total_score, $status, $user_id);
        $stmt_update->execute();
        $stmt_update->close();
        
        $stmt_insert = $conn->prepare("INSERT INTO test_history (user_id, score, status, pendidikan, lama_bekerja) VALUES (?, ?, ?, ?, ?)");
        $stmt_insert->bind_param("iisss", $user_id, $total_score, $status, $pendidikan, $lama_bekerja);
        $stmt_insert->execute();
        $stmt_insert->close();
        
        header("location: dashboard.php");
        exit;
    } else {
        $error_message = "Harap jawab semua 30 pertanyaan sebelum mengirim.";
    }
}

// Kode untuk mengambil pertanyaan dari DB
$questions = [];
if (!$conn->connect_error) {
    $sql = "SELECT id, question_text, question_order FROM questions ORDER BY question_order ASC";
    $result = $conn->query($sql);
    if ($result->num_rows > 0) { while($row = $result->fetch_assoc()) { $questions[] = $row; } }
}
$conn->close();
?>

<style>
    /* CSS untuk halaman kuesioner format panjang */
    .quiz-container {
        background-color: #fff; width: 800px; max-width: 95%;
        border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.08);
        padding: 40px; margin: 40px auto; box-sizing: border-box;
    }
    #start-area { text-align: left; }
    #start-area h1 { text-align: center; font-size: 2em; margin-bottom: 20px; }
    #start-area p { color: #555; line-height: 1.7; }
    #start-area ul { list-style-type: none; padding-left: 0; }
    #start-area ul li { background-color: #f8f9fa; padding: 10px; border-radius: 5px; margin-bottom: 5px; border-left: 3px solid #3498db; }
    #start-btn { margin-top: 20px; float: right; padding: 15px 40px; border: none; border-radius: 25px; font-size: 1em; font-weight: 600; cursor: pointer; background-color: #3498db; color: white; }
    .hidden { display: none; }
    .question-group h3 { font-size: 1.1em; font-weight: 500; color: #333; margin-bottom: 15px; }
    .question-group .required { color: #d93025; }
    .options label { display: block; background-color: #f8f9fa; border: 2px solid #dee2e6; padding: 15px; border-radius: 10px; cursor: pointer; margin-bottom: 10px; }
    .question-card { background-color: #fff; border: 1px solid #eee; padding: 20px; border-radius: 8px; margin-bottom: 20px; }
    .question-scale .scale-options { display: flex; justify-content: space-around; }
    .question-scale .scale-options label { flex-direction: column; align-items: center; cursor: pointer; }
    .btn-submit { display: block; width: 100%; padding: 15px; background-color: #28a745; color: white; border: none; border-radius: 8px; font-size: 1.2em; font-weight: 600; cursor: pointer; margin-top: 20px; }
    .error-message { color: #d93025; background-color: #fbe9e7; border: 1px solid #ffab91; padding: 15px; border-radius: 5px; margin-bottom: 20px; text-align: center; }
</style>

<div class="main-container" style="padding:0;">
    <div class="quiz-container">
        <div id="start-area">
            <h1>Petunjuk Pengisian</h1>
            <p>Selamat datang di Kuesioner Deteksi Burnout...</p>
            <p>Jawablah setiap pertanyaan sesuai dengan kondisi yang paling menggambarkan diri Anda...</p>
            <ul>
                <li><strong>Skala 1 :</strong> Tidak Pernah</li>
                <li><strong>Skala 2 :</strong> Kadang-kadang</li>
                <li><strong>Skala 3 :</strong> Sering</li>
                <li><strong>Skala 4 :</strong> Sangat Sering</li>
            </ul>
            <p>Partisipasi Anda sangat berarti...</p>
            <button class="btn-next" id="start-btn">Saya Mengerti, Mulai Tes</button>
            <div style="clear: both;"></div>
        </div>

        <form id="quiz-form" action="kuesioner.php" method="POST" class="hidden">
            <?php if ($error_message): ?>
                <div class="error-message"><?php echo $error_message; ?></div>
            <?php endif; ?>

            <div class="question-card">
                <div class="question-group">
                    <h3>Pendidikan <span class="required">*</span></h3>
                    <div class="options">
                        <label><input type="radio" name="pendidikan" value="D3" required> D3</label>
                        <label><input type="radio" name="pendidikan" value="S1"> S1</label>
                        <label><input type="radio" name="pendidikan" value="S2"> S2</label>
                    </div>
                </div>
                <div class="question-group" style="margin-top: 25px;">
                    <h3>Lama Bekerja <span class="required">*</span></h3>
                    <div class="options">
                        <label><input type="radio" name="lama_bekerja" value="1-11 bulan" required> 1-11 bulan</label>
                        <label><input type="radio" name="lama_bekerja" value="1-5 tahun"> 1-5 tahun</label>
                        <label><input type="radio" name="lama_bekerja" value="6-10 tahun"> 6-10 tahun</label>
                        <label><input type="radio" name="lama_bekerja" value="11-15 tahun"> 11-15 tahun</label>
                        <label><input type="radio" name="lama_bekerja" value="16-20 tahun"> 16-20 tahun</label>
                        <label><input type="radio" name="lama_bekerja" value="> 21 tahun"> > 21 tahun</label>
                    </div>
                </div>
            </div>

            <?php foreach($questions as $question): ?>
            <div class="question-card">
                <div class="question-group">
                    <h3><?php echo $question['question_order']; ?>. <?php echo htmlspecialchars($question['question_text']); ?> <span class="required">*</span></h3>
                    <div class="question-scale">
                        <div class="scale-options">
                            <label>1<br><input type="radio" name="answers[<?php echo $question['id']; ?>]" value="1" required></label>
                            <label>2<br><input type="radio" name="answers[<?php echo $question['id']; ?>]" value="2"></label>
                            <label>3<br><input type="radio" name="answers[<?php echo $question['id']; ?>]" value="3"></label>
                            <label>4<br><input type="radio" name="answers[<?php echo $question['id']; ?>]" value="4"></label>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>

            <button type="submit" class="btn-submit">Kirim Jawaban</button>
        </form>
    </div>
</div>

<script>
    // JavaScript sederhana untuk menampilkan form setelah klik "Mulai Tes"
    const startArea = document.getElementById('start-area');
    const startBtn = document.getElementById('start-btn');
    const quizForm = document.getElementById('quiz-form');

    startBtn.addEventListener('click', () => {
        startArea.style.display = 'none'; // Sembunyikan petunjuk
        quizForm.classList.remove('hidden'); // Tampilkan formulir
    });
</script>

<?php
// Panggil template footer
require_once 'template/footer.php';
?>