<?php
// Tentukan halaman saat ini dan judulnya untuk template
$current_page = 'informasi'; // Kita anggap ini bagian dari menu Informasi
$page_title = 'Jurnal Harian - Stress Sirna';

// Panggil template header. Ini akan otomatis memulai session dan menampilkan navbar.
require_once 'template/header.php';

// --- Mulai PHP Logic khusus untuk halaman ini ---
$conn = new mysqli("localhost", "root", "", "stress_sirna_db");
$user_id = $_SESSION['userid'];
$message = '';

// Proses simpan entri jurnal baru
if ($_SERVER["REQUEST_METHOD"] == "POST" && !empty($_POST['entry_text'])) {
    $stmt = $conn->prepare("INSERT INTO daily_journal (user_id, entry_text) VALUES (?, ?)");
    $stmt->bind_param("is", $user_id, $_POST['entry_text']);
    if($stmt->execute()) {
        $message = "Jurnal berhasil disimpan!";
    }
    $stmt->close();
}

// Ambil riwayat jurnal pengguna
$journals = $conn->query("SELECT entry_text, DATE_FORMAT(entry_date, '%d %M %Y, %H:%i') as formatted_date FROM daily_journal WHERE user_id = $user_id ORDER BY entry_date DESC");
$conn->close();
?>

<style>
    /* CSS khusus untuk halaman ini */
    textarea { 
        width: 100%; 
        min-height: 120px; 
        border-radius: 8px; 
        border: 1px solid #ccc; 
        padding: 10px; 
        font-family: 'Poppins', sans-serif; 
        box-sizing: border-box; 
    }
    .btn-submit-jurnal { 
        padding: 12px 35px; 
        background-color: #28a745; 
        color: white; 
        border: none; 
        border-radius: 5px; 
        font-size: 1em; 
        cursor: pointer; 
        float: right; 
        margin-top: 10px; 
    }
    .journal-entry { 
        border-bottom: 1px solid #eee; 
        padding: 15px 0; 
    }
    .journal-entry:last-child { 
        border-bottom: none; 
    }
    .journal-date { 
        font-weight: 600; 
        color: #3498db; 
        margin-bottom: 5px; 
    }
    .journal-text { 
        color: #555; 
        line-height: 1.6; 
    }
</style>

<div class="main-container">
    <?php if($message): ?>
        <div class="card" style="background-color: #d4edda; color: #155724; text-align:center; padding: 15px;">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>

    <div class="card">
        <h1>Jurnal Harian</h1>
        <p style="text-align: center; color: #555;">Gunakan jurnal ini untuk mencatat perasaan, pikiran, atau peristiwa apa pun yang Anda alami hari ini. Menulis jurnal adalah cara yang baik untuk refleksi diri.</p>
        <form action="jurnal.php" method="POST">
            <textarea name="entry_text" placeholder="Tuliskan apa yang Anda rasakan hari ini..." required></textarea>
            <button type="submit" class="btn-submit-jurnal">Simpan Jurnal</button>
            <div style="clear:both;"></div>
        </form>
    </div>
    
    <div class="card">
        <h2>Riwayat Jurnal Anda</h2>
        <?php if($journals->num_rows > 0): ?>
            <?php while($entry = $journals->fetch_assoc()): ?>
            <div class="journal-entry">
                <p class="journal-date"><?php echo $entry['formatted_date']; ?></p>
                <p class="journal-text"><?php echo nl2br(htmlspecialchars($entry['entry_text'])); ?></p>
            </div>
            <?php endwhile; ?>
        <?php else: ?>
            <p style="text-align:center; color: #777;">Anda belum memiliki entri jurnal.</p>
        <?php endif; ?>
    </div>
</div>

<?php
// Panggil template footer untuk menutup halaman
require_once 'template/footer.php';
?>