<?php
// Tentukan halaman saat ini dan judulnya untuk template
$current_page = 'informasi';
$page_title = 'Jadwal Istirahat - Stress Sirna';

// Panggil template header
require_once 'template/header.php';

// Ambil konten dari database
$conn = new mysqli("localhost", "root", "", "stress_sirna_db");
$contents_raw = $conn->query("SELECT content_key, content_value FROM site_content WHERE content_group = 'jadwal'");
$content = [];
while($row = $contents_raw->fetch_assoc()) { $content[$row['content_key']] = $row['content_value']; }
$conn->close();
?>

<style>
    /* CSS khusus untuk halaman ini agar terlihat elegan */
    .content-wrapper {
        display: flex;
        align-items: center;
        gap: 40px; /* Jarak antara ikon dan teks */
    }
    .icon-container {
        flex-shrink: 0; /* Mencegah ikon menyusut */
        width: 80px;
        height: 80px;
        background-color: #3498db;
        border-radius: 50%;
        display: flex;
        justify-content: center;
        align-items: center;
    }
    .icon-container i {
        font-size: 2.5em;
        color: white;
    }
    .text-container {
        text-align: left;
    }
    .text-container h1 {
        text-align: left;
        margin: 0 0 10px 0;
        font-size: 1.8em;
        color: #2c3e50;
    }
    .text-container p {
        text-align: left;
        margin: 0;
        color: #6c757d; /* Warna teks lebih lembut */
        line-height: 1.7;
    }

    /* Penyesuaian untuk tampilan HP */
    @media (max-width: 768px) {
        .content-wrapper {
            flex-direction: column; /* Ubah layout jadi vertikal di HP */
            text-align: center;
            gap: 20px;
        }
        .text-container h1, .text-container p {
            text-align: center; /* Pusatkan teks di HP */
        }
    }
</style>

<div class="main-container">
    <div class="card">
        <div class="content-wrapper">
            <div class="icon-container">
                <i class="fas fa-clock"></i>
            </div>
            <div class="text-container">
                <h1><?php echo $content['jadwal_title'] ?? 'Judul Jadwal'; ?></h1>
                <p><?php echo $content['jadwal_desc'] ?? 'Deskripsi...'; ?></p>
            </div>
        </div>
    </div>
</div>

<?php
// Panggil template footer untuk menutup halaman
require_once 'template/footer.php';
?>