<?php
// Tentukan halaman saat ini dan judulnya untuk template
$current_page = 'intervensi';
$page_title = 'Rekomendasi Intervensi - Stress Sirna';

// Panggil template header. Ini akan otomatis memulai session dan menampilkan navbar.
require_once 'template/header.php';

// --- Mulai PHP Logic khusus untuk halaman ini ---
$servername = "localhost"; $db_username = "root"; $db_password = ""; $dbname = "stress_sirna_db";
$conn = new mysqli($servername, $db_username, $db_password, $dbname);

$burnout_status = 'Belum dinilai';
$burnout_score = 0;
// Ambil data user
if (!$conn->connect_error) {
    $stmt = $conn->prepare("SELECT burnout_status, burnout_score FROM users WHERE id = ?");
    $stmt->bind_param("i", $_SESSION['userid']);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($user = $result->fetch_assoc()) {
        $burnout_status = $user['burnout_status'];
        $burnout_score = $user['burnout_score'];
    }
    $stmt->close();
}

// Ambil semua konten intervensi dari database
$contents_raw = $conn->query("SELECT content_key, content_value FROM site_content WHERE content_group = 'intervensi'");
$content = [];
while($row = $contents_raw->fetch_assoc()) {
    $content[$row['content_key']] = $row['content_value'];
}
$conn->close();

// Hitung persentase skor untuk progress bar
$min_score = 30;
$max_score = 120;
$score_percentage = (($burnout_score - $min_score) / ($max_score - $min_score)) * 100;
if ($score_percentage < 0) $score_percentage = 0;
if ($score_percentage > 100) $score_percentage = 100;
?>

<style>
    /* CSS khusus untuk halaman intervensi */
    .intervensi-card {
        background-color: #ffffff;
        border-radius: 15px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.05);
        overflow: hidden;
    }
    .card-header-banner { padding: 25px; text-align: center; color: white; }
    .card-header-banner h1 { margin-top: 0; font-size: 2.2em; }
    .card-content { padding: 35px; }
    .card-content .status-level { font-size: 1.8em; font-weight: 700; text-align: center; margin-bottom: 25px; }
    .card-content .description { text-align: center; margin-bottom: 30px; line-height: 1.6; color: #555; }
    .recommendation-list { list-style: none; padding: 0; margin: 0 auto; max-width: 600px; }
    .recommendation-list li { display: flex; align-items: flex-start; margin-bottom: 20px; font-size: 1.05em; line-height: 1.5; }
    .recommendation-list li .icon { font-size: 1.5em; margin-right: 15px; color: #3498db; width: 30px; text-align: center; flex-shrink: 0; }
    .recommendation-list li p { margin: 0; }
    .status-rendah .card-header-banner { background-color: #28a745; }
    .status-rendah .status-level { color: #28a745; }
    .status-sedang .card-header-banner { background-color: #ffc107; }
    .status-sedang .status-level { color: #ffc107; }
    .status-berat .card-header-banner { background-color: #dc3545; }
    .status-berat .status-level { color: #dc3545; }
    .status-default .card-header-banner { background-color: #6c757d; }
    .status-default .status-level { color: #6c757d; }
    .btn-kuesioner { display: block; width: fit-content; margin: 30px auto 0; background-color: #3498db; color: white; padding: 12px 30px; border-radius: 8px; text-decoration: none; font-weight: 600; transition: background-color 0.3s; }
    .stress-meter-container { text-align: center; margin-bottom: 30px; }
    .stress-meter-bar { width: 80%; max-width: 500px; height: 15px; background-color: #e0e0e0; border-radius: 10px; margin: 10px auto; overflow: hidden; }
    .stress-meter-fill { height: 100%; width: <?php echo $score_percentage; ?>%; background-color: #3498db; border-radius: 10px; transition: width 1s ease-out; }
    .stress-meter-labels { display: flex; justify-content: space-between; width: 80%; max-width: 500px; margin: auto; font-size: 0.9em; color: #777; }
</style>

<div class="main-container">
    <div class="intervensi-card <?php if ($burnout_status == 'Rendah') echo 'status-rendah'; elseif ($burnout_status == 'Sedang') echo 'status-sedang'; elseif ($burnout_status == 'Berat') echo 'status-berat'; else echo 'status-default'; ?>">
        <div class="card-header-banner">
            <h1>Rekomendasi Intervensi</h1>
        </div>
        
        <div class="card-content">
            <?php if ($burnout_status != 'Belum dinilai') : ?>
                <div class="stress-meter-container">
                    <p>Skor Stres Anda: <strong><?php echo $burnout_score; ?></strong> (dari 120)</p>
                    <div class="stress-meter-bar">
                        <div class="stress-meter-fill"></div>
                    </div>
                    <div class="stress-meter-labels">
                        <span>Rendah</span>
                        <span>Tinggi</span>
                    </div>
                </div>
            <?php endif; ?>

            <div class="status-level">LEVEL: <?php echo strtoupper($burnout_status); ?></div>
            
            <?php if ($burnout_status == 'Rendah') : ?>
                <p class="description"><?php echo $content['intervensi_rendah_desc']; ?></p>
                <ul class="recommendation-list">
                    <li><span class="icon"><i class="fas fa-book-open"></i></span> <p><?php echo $content['intervensi_rendah_1']; ?></p></li>
                    <li><span class="icon"><i class="fas fa-leaf"></i></span> <p><?php echo $content['intervensi_rendah_2']; ?></p></li>
                    <li><span class="icon"><i class="fas fa-users"></i></span> <p><?php echo $content['intervensi_rendah_3']; ?></p></li>
                    <li><span class="icon"><i class="fas fa-running"></i></span> <p><?php echo $content['intervensi_rendah_4']; ?></p></li>
                </ul>
            <?php elseif ($burnout_status == 'Sedang') : ?>
                <p class="description"><?php echo $content['intervensi_sedang_desc']; ?></p>
                <ul class="recommendation-list">
                    <li><span class="icon"><i class="fas fa-comments"></i></span> <p><?php echo $content['intervensi_sedang_1']; ?></p></li>
                    <li><span class="icon"><i class="fas fa-handshake"></i></span> <p><?php echo $content['intervensi_sedang_2']; ?></p></li>
                    <li><span class="icon"><i class="fas fa-clock"></i></span> <p><?php echo $content['intervensi_sedang_3']; ?></p></li>
                </ul>
            <?php elseif ($burnout_status == 'Berat') : ?>
                <p class="description"><?php echo $content['intervensi_berat_desc']; ?></p>
                <ul class="recommendation-list">
                    <li><span class="icon"><i class="fas fa-stethoscope"></i></span> <p><?php echo $content['intervensi_berat_1']; ?></p></li>
                    <li><span class="icon"><i class="fas fa-user-friends"></i></span> <p><?php echo $content['intervensi_berat_2']; ?></p></li>
                </ul>
            <?php else : ?>
                <p class="description">Silakan isi kuesioner untuk mendapatkan rekomendasi.</p>
                <a href="kuesioner.php" class="btn-kuesioner">Isi Kuesioner Sekarang</a>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
// Panggil template footer untuk menutup halaman
require_once 'template/footer.php';
?>