<?php
// Tentukan halaman saat ini dan judulnya untuk template
$current_page = 'informasi';
$page_title = 'Pusat Informasi - Stress Sirna';

// Panggil template header. Ini akan otomatis memulai session dan menampilkan navbar.
require_once 'template/header.php';
?>

<style>
    /* CSS khusus untuk halaman informasi */
    .info-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-top: 30px; }
    .info-link { display: block; background-color: #f8f9fa; border: 1px solid #eee; padding: 25px; border-radius: 10px; text-decoration: none; color: #333; transition: all 0.3s; }
    .info-link:hover { transform: translateY(-5px); box-shadow: 0 8px 15px rgba(0,0,0,0.08); border-color: #3498db; }
    .info-link h3 { margin: 0 0 10px 0; color: #3498db; }
    .info-link p { margin: 0; color: #555; }

    /* Penyesuaian untuk tampilan HP */
    @media (max-width: 768px) {
        .info-grid {
            grid-template-columns: 1fr; /* Ubah jadi 1 kolom di HP */
        }
    }
</style>

<div class="main-container">
    <div class="card">
        <h1>Pusat Informasi</h1>
        <p style="text-align: center; color: #555;">Temukan berbagai informasi penting terkait burnout dan kesehatan mental di sini.</p>
        
        <div class="info-grid">
            <a href="gejala.php" class="info-link">
                <h3>Gejala Burnout</h3>
                <p>Kenali tanda-tanda fisik, emosional, dan perilaku dari burnout.</p>
            </a>
            <a href="mengatasi.php" class="info-link">
                <h3>Cara Mengatasi</h3>
                <p>Pelajari strategi efektif untuk mencegah dan mengatasi kondisi burnout.</p>
            </a>
        </div>
    </div>
</div>

<?php
// Panggil template footer untuk menutup halaman
require_once 'template/footer.php';
?>