<?php
// Mulai session
session_start();

// Jika pengguna SUDAH login, langsung arahkan ke dasbor.
// Mereka tidak perlu melihat halaman ini lagi.
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header("Location: dashboard.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Selamat Datang di Stress Sirna</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body, html {
            margin: 0;
            padding: 0;
            height: 100%;
            font-family: 'Poppins', sans-serif;
            background-image: url('background.jpg'); /* Pastikan file background.jpg ada */
            background-size: cover;
            background-position: center;
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
            color: #333;
        }
        .welcome-container {
            background-color: rgba(255, 255, 255, 0.95);
            padding: 50px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
            max-width: 500px;
        }
        .logo {
            max-width: 100px;
            margin-bottom: 15px;
        }
        h1 {
            font-size: 2.5em;
            color: #2c3e50;
            margin: 0;
        }
        .tagline {
            color: #7f8c8d;
            margin-bottom: 40px;
            font-size: 1.1em;
        }
        .btn {
            display: block;
            width: 100%;
            padding: 15px;
            border-radius: 25px;
            font-size: 1.2em;
            font-weight: 600;
            cursor: pointer;
            text-decoration: none;
            transition: all 0.3s;
            margin-bottom: 20px;
            box-sizing: border-box;
        }
        .btn-primary {
            background-color: #3498db;
            color: white;
            border: none;
        }
        .btn-primary:hover {
            background-color: #2980b9;
        }
        .account-links {
            font-size: 1em;
            color: #555;
        }
        .account-links a {
            color: #3498db;
            text-decoration: none;
            font-weight: 600;
        }
        .account-links a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="welcome-container">
        <img src="logo.png" alt="Stress Sirna Logo" class="logo">
        <h1>Stress Sirna</h1>
        <p class="tagline">MENCEGAH BURNOUT, MERAWAT SENYUM</p>

        <a href="kuesioner.php" class="btn btn-primary">Mulai Tes</a>

        <div class="account-links">
            Sudah punya akun? <a href="login.php">Masuk</a> atau <a href="register.php">Daftar</a>
        </div>
    </div>
</body>
</html>