<?php
// Tentukan halaman saat ini dan judulnya untuk template
$current_page = 'informasi'; // Kita anggap ini bagian dari menu Informasi
$page_title = 'Gejala Burnout - Stress Sirna';

// Panggil template header
require_once 'template/header.php';

// Ambil konten dari database
$conn = new mysqli("localhost", "root", "", "stress_sirna_db");
$contents_raw = $conn->query("SELECT content_key, content_value FROM site_content WHERE content_group = 'gejala'");
$content = [];
while($row = $contents_raw->fetch_assoc()) { $content[$row['content_key']] = $row['content_value']; }
$conn->close();
?>

<style>
    /* CSS khusus untuk halaman gejala */
    .gejala-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; }
    .gejala-item { background-color: #f8f9fa; border-left: 5px solid; padding: 20px; border-radius: 8px; }
    .gejala-item h3 { margin: 0 0 10px 0; display: flex; align-items: center; gap: 10px; }
    /* Warna aksen untuk setiap kategori */
    .gejala-item.fisik { border-color: #e74c3c; } .gejala-item.fisik h3 { color: #e74c3c; }
    .gejala-item.emosi { border-color: #f39c12; } .gejala-item.emosi h3 { color: #f39c12; }
    .gejala-item.perilaku { border-color: #3498db; } .gejala-item.perilaku h3 { color: #3498db; }
</style>

<div class="main-container">
    <div class="card">
        <h1>Gejala Umum Burnout</h1>
        <p style="text-align: center; color: #555;">Kenali tanda-tanda burnout untuk dapat menanganinya lebih awal. Gejala dapat bervariasi pada setiap individu, namun umumnya terbagi menjadi tiga kategori utama:</p>
        
        <div class="gejala-grid" style="margin-top:30px;">
            <div class="gejala-item fisik">
                <h3><i class="fas fa-heartbeat"></i> <?php echo $content['gejala_fisik_title'] ?? 'Fisik'; ?></h3>
                <ul>
                    <li><?php echo $content['gejala_fisik_1'] ?? 'Gejala fisik 1...'; ?></li>
                    <li><?php echo $content['gejala_fisik_2'] ?? 'Gejala fisik 2...'; ?></li>
                </ul>
            </div>
            <div class="gejala-item emosi">
                <h3><i class="fas fa-sad-tear"></i> <?php echo $content['gejala_emosi_title'] ?? 'Emosi'; ?></h3>
                <ul>
                    <li><?php echo $content['gejala_emosi_1'] ?? 'Gejala emosi 1...'; ?></li>
                    <li><?php echo $content['gejala_emosi_2'] ?? 'Gejala emosi 2...'; ?></li>
                </ul>
            </div>
            <div class="gejala-item perilaku">
                <h3><i class="fas fa-running"></i> <?php echo $content['gejala_perilaku_title'] ?? 'Perilaku'; ?></h3>
                <ul>
                    <li><?php echo $content['gejala_perilaku_1'] ?? 'Gejala perilaku 1...'; ?></li>
                    <li><?php echo $content['gejala_perilaku_2'] ?? 'Gejala perilaku 2...'; ?></li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php
// Panggil template footer
require_once 'template/footer.php';
?>