<?php
// forgot_password.php
$message = '';
$message_type = ''; // 'success' or 'error'

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $servername = "localhost"; $db_username = "root"; $db_password = ""; $dbname = "stress_sirna_db";
    $conn = new mysqli($servername, $db_username, $db_password, $dbname);

    $email = $_POST['email'];

    // Cek apakah email ada di database
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Jika email ada, buat token unik
        $token = bin2hex(random_bytes(50));
        // Atur waktu kedaluwarsa token (misal: 1 jam dari sekarang)
        $expires = date("Y-m-d H:i:s", time() + 3600);

        // Simpan token ke database
        $stmt_update = $conn->prepare("UPDATE users SET reset_token = ?, reset_token_expires_at = ? WHERE email = ?");
        $stmt_update->bind_param("sss", $token, $expires, $email);
        $stmt_update->execute();

        // **SIMULASI PENGIRIMAN EMAIL**
        // Buat link reset
        $reset_link = "http://localhost/stress-sirna/reset_password.php?token=" . $token;
        
        // Tampilkan link di layar
        $message = "Email ditemukan! Link reset akan dikirim ke email Anda.<br><br><strong>(SIMULASI) Klik link di bawah ini untuk reset password:</strong><br><a href='" . $reset_link . "'>" . $reset_link . "</a>";
        $message_type = 'success';

    } else {
        $message = "Error: Email tidak ditemukan di sistem kami.";
        $message_type = 'error';
    }
    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Lupa Password - Stress Sirna</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #f4f7f9; display: flex; justify-content: center; align-items: center; height: 100vh; }
        .container { background-color: #fff; padding: 40px; border-radius: 10px; box-shadow: 0 5px 15px rgba(0,0,0,0.1); width: 400px; text-align: center; }
        h2 { margin-top: 0; }
        .form-group { margin-bottom: 20px; text-align: left; }
        label { display: block; margin-bottom: 5px; }
        input[type="email"] { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 5px; box-sizing: border-box; }
        .btn { width: 100%; padding: 12px; background-color: #3498db; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 1em; }
        .message { padding: 15px; border-radius: 5px; margin-top: 20px; word-wrap: break-word; }
        .message.success { background-color: #d4edda; color: #155724; }
        .message.error { background-color: #f8d7da; color: #721c24; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Lupa Password</h2>
        <p>Masukkan alamat email Anda, dan kami akan mengirimkan link untuk mereset password Anda.</p>
        <form action="forgot_password.php" method="POST">
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" name="email" id="email" required>
            </div>
            <button type="submit" class="btn">Kirim Link Reset</button>
        </form>
        <?php if(!empty($message)) echo '<div class="message '.$message_type.'">'.$message.'</div>'; ?>
        <p style="margin-top: 20px;"><a href="login.php">Kembali ke Login</a></p>
    </div>
</body>
</html>