<?php
// Tentukan halaman saat ini dan judulnya untuk template
$current_page = 'dashboard';
$page_title = 'Dashboard - Stress Sirna';
require_once 'template/header.php';

// --- PHP Logic (Tidak ada perubahan) ---
$servername = "localhost"; $db_username = "root"; $db_password = ""; $dbname = "stress_sirna_db";
$conn = new mysqli($servername, $db_username, $db_password, $dbname);
$burnout_status = 'Belum dinilai'; $chart_labels = []; $chart_data = [];
if (!$conn->connect_error) {
    $user_id = $_SESSION['userid'];
    $stmt_user = $conn->prepare("SELECT username, burnout_status FROM users WHERE id = ?");
    $stmt_user->bind_param("i", $user_id); $stmt_user->execute(); $result_user = $stmt_user->get_result();
    if($user = $result_user->fetch_assoc()) { $burnout_status = $user['burnout_status']; }
    $stmt_user->close();
    
    $stmt_history = $conn->prepare("SELECT score, DATE_FORMAT(test_date, '%d %b') as test_day FROM test_history WHERE user_id = ? ORDER BY test_date DESC LIMIT 7");
    $stmt_history->bind_param("i", $user_id);
    $stmt_history->execute();
    $result_history = $stmt_history->get_result();
    while($row = $result_history->fetch_assoc()) {
        array_unshift($chart_labels, $row['test_day']);
        array_unshift($chart_data, $row['score']);
    }
    $stmt_history->close(); 
    $conn->close();
}
$emoji = '🤔'; if ($burnout_status == 'Rendah') $emoji = '😊'; if ($burnout_status == 'Sedang') $emoji = '😐'; if ($burnout_status == 'Berat') $emoji = '😟';
$chart_labels_json = json_encode($chart_labels);
$chart_data_json = json_encode($chart_data);
?>

<style>
    /* CSS khusus untuk halaman dasbor */
    .dashboard-grid {
        display: grid;
        grid-template-columns: 2fr 1fr;
        grid-template-areas: "status reminder" "status akses-cepat";
        grid-gap: 30px;
        align-items: start;
    }

    .status-card { grid-area: status;}
    .reminder-card { grid-area: reminder; }
    .akses-cepat-card { grid-area: akses-cepat; }

    .card h2 { font-family: 'Fredoka One', cursive; letter-spacing: 1px;}
    .status-card-content { display: flex; align-items: center; gap: 20px; }
    .status-card-content .emoji { font-size: 3.5em; }
    .status-card-content .text { line-height: 1.4; }
    .status-card-content .text span { font-size: 1em; color: #7f8c8d; }
    .status-card-content .text strong { display: block; font-size: 1.8em; }
    
    .reminder-card { background: linear-gradient(135deg, #3498db, #2980b9); color: white; }
    .reminder-card h2 { color: white; }
    .reminder-card .btn { display: block; width: 100%; text-align: center; background-color: rgba(255,255,255,0.9); color: #2980b9; padding: 15px; border-radius: 10px; text-decoration: none; font-weight: 600; margin-top: 15px; box-sizing: border-box; }
    
    .akses-cepat-list { display: flex; flex-direction: column; gap: 20px; }
    .akses-cepat-item { display: flex; align-items: center; gap: 15px; }
    .akses-cepat-icon { flex-shrink: 0; width: 60px; height: 60px; background-color: #fff5d1; border-radius: 50%; display: flex; justify-content: center; align-items: center; font-size: 1.8em; color: #f39c12; }
    .akses-cepat-link { flex-grow: 1; text-decoration: none; color: white; background-color: #87CEEB; padding: 15px 20px; border-radius: 50px; font-weight: 600; text-align: center; }

    @media (max-width: 992px) {
        .dashboard-grid {
            grid-template-columns: 1fr;
            grid-template-areas: "status" "reminder" "akses-cepat";
        }
    }
</style>

<div class="main-container">
    <div class="dashboard-grid">
        <div class="card status-card">
            <h2>Status Burnout Terkini</h2>
            <div class="status-card-content">
                <span class="emoji"><?php echo $emoji; ?></span>
                <div class="text">
                    <span>Tingkat Stres Anda:</span>
                    <strong><?php echo htmlspecialchars($burnout_status); ?></strong>
                </div>
            </div>
            <div class="trend-chart" style="margin-top:20px;">
                
                <h3>Tren Tingkat Stres (7 Tes Terakhir)</h3>
                
                <?php if (!empty($chart_data)): ?>
                    <canvas id="stressTrendChart"></canvas>
                <?php else: ?>
                    <p style="text-align:center; color:#777; padding: 20px; background-color:#f9f9f9; border-radius:8px;">
                        Anda belum memiliki riwayat tes. Isi kuesioner untuk melihat statistik Anda di sini.
                    </p>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="card reminder-card">
            <h2>Pengingat Penting</h2>
            <p>Cek kondisi kesehatan mental Anda secara rutin untuk hasil yang lebih baik.</p>
            <a href="kuesioner.php" class="btn">Isi Kuesioner Sekarang</a>
        </div>
        
        <div class="card akses-cepat-card">
            <h2>Akses Cepat</h2>
            <div class="akses-cepat-list">
                <div class="akses-cepat-item">
                    <div class="akses-cepat-icon"><i class="fas fa-history"></i></div>
                    <a href="riwayat_tes.php" class="akses-cepat-link">Riwayat Tes</a>
                </div>
                <div class="akses-cepat-item">
                    <div class="akses-cepat-icon"><i class="fas fa-leaf"></i></div>
                    <a href="relaksasi.php" class="akses-cepat-link">Panduan Relaksasi</a>
                </div>
                <div class="akses-cepat-item">
                    <div class="akses-cepat-icon"><i class="fas fa-calendar-alt"></i></div>
                    <a href="jadwal.php" class="akses-cepat-link">Jadwal Istirahat</a>
                </div>
                <div class="akses-cepat-item">
                    <div class="akses-cepat-icon"><i class="fas fa-book-open"></i></div>
                    <a href="jurnal.php" class="akses-cepat-link">Jurnal Harian</a>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const canvas = document.getElementById('stressTrendChart');
        if (canvas) {
            const ctx = canvas.getContext('2d');
            const labels = <?php echo $chart_labels_json; ?>;
            const dataPoints = <?php echo $chart_data_json; ?>;
            new Chart(ctx, { /* ... kode chart.js ... */ });
        }
    });
</script>

<?php
require_once 'template/footer.php';
?>