<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!isset($_SESSION['admin_loggedin']) || $_SESSION['admin_loggedin'] !== true) { header("location: /stress-sirna/admin/"); exit; }
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title ?? 'Admin Panel'; ?> - Stress Sirna</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css"/>
    <style>
        body { font-family: 'Poppins', sans-serif; background-color: #eef2f6; margin: 0; display: flex; }
        .sidebar { width: 250px; background-color: #1e293b; color: white; min-height: 100vh; position: fixed; top: 0; left: 0; z-index: 1001; box-shadow: 2px 0 10px rgba(0,0,0,0.1); transition: transform 0.3s ease-in-out; }
        .sidebar-header { padding: 20px; text-align: center; background-color: rgba(0,0,0,0.2); }
        .sidebar-header h3 { margin: 0; }
        .sidebar-menu { list-style: none; padding: 10px 0; }
        .sidebar-menu li a { display: block; padding: 15px 25px; color: #cbd5e1; text-decoration: none; transition: all 0.3s; border-left: 4px solid transparent; }
        .sidebar-menu li a:hover { background-color: rgba(255,255,255,0.05); color: #fff; }
        .sidebar-menu li a.active { background-color: rgba(59, 130, 246, 0.2); color: #fff; font-weight: 600; border-left: 4px solid #3b82f6; }
        .sidebar-menu li a i { margin-right: 12px; width: 20px; }
        .main-content { margin-left: 250px; width: calc(100% - 250px); padding: 30px; transition: margin-left 0.3s ease-in-out; }
        .card { background-color: #fff; padding: 25px; border-radius: 8px; box-shadow: 0 4px 12px rgba(0,0,0,0.08); margin-bottom: 20px; border-top: 4px solid #3b82f6; }
        .card-header { display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid #eee; padding-bottom: 15px; margin-bottom: 20px; }
        .card-header h1, .card-header h2 { margin: 0; color: #1e293b; }
        .mobile-header { display: none; background-color: #1e293b; color: white; padding: 15px; display: flex; align-items: center; box-shadow: 0 2px 5px rgba(0,0,0,0.2); }
        .mobile-header .hamburger-btn { background: none; border: none; color: white; font-size: 1.5rem; cursor: pointer; }
        .mobile-header h3 { margin: 0; padding-left: 15px; }
        .overlay { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.5); z-index: 1000; }
        .overlay.active { display: block; }
        .btn { padding: 10px 20px; border-radius: 5px; text-decoration: none; border: none; cursor: pointer; font-weight: 600; transition: background-color 0.2s; display: inline-flex; align-items: center; gap: 8px; }
        .btn-success { background-color: #10b981; color: white; }
        .btn-success:hover { background-color: #059669; }

        /* CSS RESPONSIF UNTUK HP */
        @media (max-width: 768px) {
            .sidebar { transform: translateX(-100%); }
            .sidebar.active { transform: translateX(0); }
            .main-content {
                margin-left: 0;
                width: 100%;
                box-sizing: border-box; /* Penting */
                /* PERBAIKAN UTAMA DI SINI */
                padding: 15px; /* Memberi ruang di sisi kiri-kanan & atas-bawah */
            }
            .main-content .card {
                /* Kita hapus style yang membuat mepet */
                margin-bottom: 20px;
                padding: 20px;
            }
            .mobile-header { display: flex; }
            body { display: block; }
        }
    </style>
</head>
<body>
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header"><h3>Admin Panel</h3></div>
        <ul class="sidebar-menu">
            <li><a href="dashboard.php" class="<?php echo ($current_page == 'dashboard') ? 'active' : ''; ?>"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="manage_questions.php" class="<?php echo ($current_page == 'questions') ? 'active' : ''; ?>"><i class="fas fa-question-circle"></i> Pertanyaan</a></li>
            <li><a href="manage_content.php" class="<?php echo ($current_page == 'content') ? 'active' : ''; ?>"><i class="fas fa-edit"></i> Kelola Konten</a></li>
            <li><a href="manage_users.php" class="<?php echo ($current_page == 'users') ? 'active' : ''; ?>"><i class="fas fa-users"></i> Pengguna</a></li>
            <li><a href="settings.php" class="<?php echo ($current_page == 'settings') ? 'active' : ''; ?>"><i class="fas fa-cog"></i> Pengaturan</a></li>
            <li><a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
        </ul>
    </div>
    <div class="overlay" id="overlay"></div>
    <div class="main-content" id="main-content">
        <div class="mobile-header">
            <button class="hamburger-btn" id="hamburger-btn"><i class="fas fa-bars"></i></button>
            <h3><?php echo $page_title ?? 'Admin Panel'; ?></h3>
        </div>