<?php
$page_title = 'Pengaturan Admin';
$current_page = 'settings';
require_once 'template/header.php';

$conn = new mysqli("localhost", "root", "", "stress_sirna_db");
$admin_id = $_SESSION['admin_id'];
$message = '';
$message_type = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $old_password = $_POST['old_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    if ($new_password !== $confirm_password) {
        $message = "Error: Konfirmasi password baru tidak cocok.";
        $message_type = 'error';
    } else {
        $stmt_pass = $conn->prepare("SELECT password FROM users WHERE id = ?");
        $stmt_pass->bind_param("i", $admin_id);
        $stmt_pass->execute();
        $result = $stmt_pass->get_result();
        $admin = $result->fetch_assoc();
        $hashed_password = $admin['password'];
        $stmt_pass->close();

        if (password_verify($old_password, $hashed_password)) {
            $new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $stmt_update = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
            $stmt_update->bind_param("si", $new_hashed_password, $admin_id);
            if ($stmt_update->execute()) {
                $message = "Password berhasil diperbarui!";
                $message_type = 'success';
            } else {
                $message = "Error: Gagal memperbarui password.";
                $message_type = 'error';
            }
            $stmt_update->close();
        } else {
            $message = "Error: Password lama yang Anda masukkan salah.";
            $message_type = 'error';
        }
    }
}
$conn->close();
?>
<style>
    .form-group { margin-bottom: 15px; }
    .form-group label { display: block; font-weight: 500; margin-bottom: 5px; }
    .form-group input { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px; box-sizing: border-box; }
    .message { padding: 15px; border-radius: 5px; margin-bottom: 20px; }
    .message.success { background-color: #d4edda; color: #155724; }
    .message.error { background-color: #f8d7da; color: #721c24; }
</style>

<?php if ($message): ?>
    <div class="message <?php echo $message_type; ?>"><?php echo $message; ?></div>
<?php endif; ?>

<div class="card">
    <div class="card-header">
        <h1>Ubah Password Admin</h1>
    </div>
    <form action="settings.php" method="POST">
        <div class="form-group">
            <label for="old_password">Password Lama</label>
            <input type="password" id="old_password" name="old_password" required>
        </div>
        <div class="form-group">
            <label for="new_password">Password Baru</label>
            <input type="password" id="new_password" name="new_password" required>
        </div>
        <div class="form-group">
            <label for="confirm_password">Konfirmasi Password Baru</label>
            <input type="password" id="confirm_password" name="confirm_password" required>
        </div>
        <button type="submit" class="btn btn-success">Simpan Perubahan</button>
    </form>
</div>

<?php require_once 'template/footer.php'; ?>