<?php
// /admin/reset_password.php
$message = '';
$message_type = '';
$token_is_valid = false;
$conn = new mysqli("localhost", "root", "", "stress_sirna_db");

if (isset($_GET['token'])) {
    $token = $_GET['token'];
    $stmt = $conn->prepare("SELECT id FROM users WHERE reset_token = ? AND reset_token_expires_at > NOW()");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    if ($stmt->get_result()->num_rows > 0) {
        $token_is_valid = true;
    } else {
        $message = "Link reset tidak valid atau sudah kedaluwarsa.";
        $message_type = 'error';
    }
    $stmt->close();
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['token'])) {
    $token = $_POST['token'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    if ($new_password !== $confirm_password) {
        $message = "Konfirmasi password tidak cocok.";
        $message_type = 'error';
        $token_is_valid = true;
    } else {
        $new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE users SET password = ?, reset_token = NULL, reset_token_expires_at = NULL WHERE reset_token = ?");
        $stmt->bind_param("ss", $new_hashed_password, $token);
        if ($stmt->execute()) {
            $message = "Password berhasil direset! Anda sekarang bisa login.";
            $message_type = 'success';
            $token_is_valid = false;
        } else {
            $message = "Terjadi kesalahan.";
            $message_type = 'error';
            $token_is_valid = true;
        }
        $stmt->close();
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Reset Password Admin</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        body, html { height: 100%; margin: 0; font-family: 'Poppins', sans-serif; display: flex; align-items: center; justify-content: center; background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%); }
        .card { background: #fff; padding: 40px; border-radius: 12px; box-shadow: 0 10px 25px rgba(0,0,0,0.1); width: 400px; text-align: center; }
        .card h2 { margin: 0 0 10px 0; }
        .card p { color: #64748b; margin-bottom: 30px; }
        .form-group { text-align: left; margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: 500; }
        .form-group input { width: 100%; padding: 12px 15px; border: 1px solid #cbd5e1; border-radius: 8px; box-sizing: border-box; }
        .btn { width: 100%; padding: 14px; background-color: #10b981; color: white; border: none; border-radius: 8px; cursor: pointer; }
        .message { padding: 15px; border-radius: 8px; margin-bottom: 20px; word-wrap: break-word; }
        .message.success { background-color: #d4edda; color: #155724; }
        .message.error { background-color: #f8d7da; color: #721c24; }
        .back-link { display: block; margin-top: 20px; color: #3b82f6; text-decoration: none; }
    </style>
</head>
<body>
    <div class="card">
        <h2>Atur Password Baru</h2>
        <?php if ($token_is_valid): ?>
            <p>Masukkan password baru Anda di bawah ini.</p>
            <form action="reset_password.php" method="POST">
                <input type="hidden" name="token" value="<?php echo htmlspecialchars($_GET['token']); ?>">
                <div class="form-group">
                    <label>Password Baru</label>
                    <input type="password" name="new_password" required>
                </div>
                <div class="form-group">
                    <label>Konfirmasi Password Baru</label>
                    <input type="password" name="confirm_password" required>
                </div>
                <button type="submit" class="btn">Reset Password</button>
            </form>
        <?php endif; ?>
        <?php if(!empty($message)) echo '<div class="message '.$message_type.'">'.$message.'</div>'; ?>
        <?php if($message_type === 'success'): ?>
             <a href="index.php" class="back-link">Lanjutkan ke Halaman Login</a>
        <?php endif; ?>
    </div>
</body>
</html>