<?php
// /admin/manage_users.php
$page_title = 'Kelola Pengguna';
$current_page = 'users';
require_once 'template/header.php';

$conn = new mysqli("localhost", "root", "", "stress_sirna_db");

if (isset($_GET['delete_id'])) {
    $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
    $stmt->bind_param("i", $_GET['delete_id']);
    $stmt->execute();
    $stmt->close();
    echo "<script>window.location.href='manage_users.php'</script>";
    exit;
}

$users = $conn->query("
    SELECT 
        u.id, u.username, u.email, 
        DATE_FORMAT(u.created_at, '%d %M %Y') as join_date,
        (SELECT status FROM test_history th WHERE th.user_id = u.id ORDER BY th.test_date DESC LIMIT 1) as last_status
    FROM users u ORDER BY u.created_at DESC
");
?>
<style>
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    th, td {
        padding: 12px 15px; /* Memberi ruang di dalam sel */
        border: 1px solid #e2e8f0;
        text-align: left;
        vertical-align: middle;
        white-space: nowrap; /* Mencegah teks turun baris */
    }
    th {
        background-color: #f8fafc;
        font-weight: 600;
        color: #475569;
    }
    td {
        color: #334155;
    }
    .action-links a {
        font-size: 1.2em;
        text-decoration: none;
    }
    .action-links .fa-trash-alt {
        color: #dc3545;
        transition: color 0.2s;
    }
    .action-links .fa-trash-alt:hover {
        color: #a71d2a;
    }
</style>

<div class="card">
    <div class="card-header">
        <h1>Daftar Pengguna</h1>
    </div>
    <div style="overflow-x:auto;">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Username</th>
                    <th>Email</th>
                    <th>Tanggal Bergabung</th>
                    <th>Status Terakhir</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if($users->num_rows > 0): ?>
                    <?php while($user = $users->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $user['id']; ?></td>
                        <td><?php echo htmlspecialchars($user['username']); ?></td>
                        <td><?php echo htmlspecialchars($user['email']); ?></td>
                        <td><?php echo $user['join_date']; ?></td>
                        <td>
                            <span style="padding: 5px 10px; border-radius: 5px; background-color: #f0f0f0; font-size: 0.9em;">
                                <?php echo htmlspecialchars($user['last_status'] ?? 'Belum ada tes'); ?>
                            </span>
                        </td>
                        <td class="action-links">
                            <a href="manage_users.php?delete_id=<?php echo $user['id']; ?>" title="Hapus Pengguna" onclick="return confirm('Apakah Anda yakin ingin menghapus pengguna ini?');">
                                <i class="fas fa-trash-alt"></i>
                            </a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="6" style="text-align:center;">Belum ada pengguna yang terdaftar.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once 'template/footer.php'; ?>