<?php
$page_title = 'Kelola Pertanyaan';
$current_page = 'questions';
require_once 'template/header.php';
$conn = new mysqli("localhost", "root", "", "stress_sirna_db");
if (isset($_GET['delete_id'])) {
    $stmt = $conn->prepare("DELETE FROM questions WHERE id = ?");
    $stmt->bind_param("i", $_GET['delete_id']);
    $stmt->execute();
    $stmt->close();
    echo "<script>window.location.href='manage_questions.php'</script>";
    exit;
}
$questions = $conn->query("SELECT id, question_text, question_order FROM questions ORDER BY question_order ASC");
?>
<style>
    /* CSS khusus untuk halaman ini */
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    th, td { padding: 12px 15px; border: 1px solid #e2e8f0; text-align: left; vertical-align: middle; white-space: nowrap; }
    .action-links a { font-size: 1.2em; text-decoration: none; }
    .action-links .fa-edit { color: #007bff; }
    .action-links .fa-trash-alt { color: #dc3545; }
</style>

<div class="card">
    <div class="card-header">
        <h1>Daftar Pertanyaan</h1>
        <a href="add_question.php" class="btn btn-success"><i class="fas fa-plus"></i> <span>Tambah Pertanyaan</span></a>
    </div>
    <div style="overflow-x:auto;">
        <table>
            <thead>
                <tr>
                    <th>No. Urut</th>
                    <th>Teks Pertanyaan</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if($questions->num_rows > 0): ?>
                    <?php while($q = $questions->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $q['question_order']; ?></td>
                        <td style="white-space: normal;"><?php echo htmlspecialchars($q['question_text']); ?></td>
                        <td class="action-links">
                            <a href="edit_question.php?id=<?php echo $q['id']; ?>" title="Edit" style="margin-right: 15px;"><i class="fas fa-edit"></i></a>
                            <a href="manage_questions.php?delete_id=<?php echo $q['id']; ?>" title="Hapus" onclick="return confirm('Yakin ingin menghapus?');"><i class="fas fa-trash-alt"></i></a>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr><td colspan="3" style="text-align:center;">Belum ada pertanyaan.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once 'template/footer.php'; ?>