<?php
$page_title = 'Kelola Konten'; $current_page = 'content';
require_once 'template/header.php';
$conn = new mysqli("localhost", "root", "", "stress_sirna_db");
$message = '';
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    foreach($_POST['content'] as $key => $value) {
        $stmt = $conn->prepare("UPDATE site_content SET content_value = ? WHERE content_key = ?");
        $stmt->bind_param("ss", $value, $key);
        $stmt->execute();
        $stmt->close();
    }
    $message = 'Konten berhasil diperbarui!';
}
$contents_raw = $conn->query("SELECT content_key, content_value, content_group FROM site_content ORDER BY content_group, id");
$contents_grouped = [];
while($row = $contents_raw->fetch_assoc()) {
    $contents_grouped[$row['content_group']][$row['content_key']] = $row['content_value'];
}
$conn->close();
?>
<style>
    .accordion-item { border: 1px solid #e2e8f0; border-radius: 8px; margin-bottom: 10px; overflow: hidden; }
    .accordion-header { background-color: #f8fafc; padding: 15px 20px; cursor: pointer; display: flex; justify-content: space-between; align-items: center; width: 100%; border: none; text-align: left; font-size: 1.1em; font-weight: 600; }
    .accordion-header i { transition: transform 0.3s; }
    .accordion-header.active i { transform: rotate(180deg); }
    .accordion-content { padding: 0 20px; max-height: 0; overflow: hidden; transition: max-height 0.3s ease-out, padding 0.3s ease-out; }
    .form-group { margin-bottom: 15px; padding-top: 15px; }
    .form-group label { font-weight: bold; }
    .form-group textarea { width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px; min-height: 80px; box-sizing: border-box; margin-top: 5px; }
</style>

<?php if($message): ?><div style="background-color: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin-bottom: 20px;"><?php echo $message; ?></div><?php endif; ?>

<form action="manage_content.php" method="POST">
    <div class="card">
        <div class="card-header">
            <h1>Editor Konten Halaman</h1>
            <button type="submit" class="btn btn-success"><i class="fas fa-save"></i> Simpan Semua Perubahan</button>
        </div>
    </div>

    <div class="accordion">
        <?php foreach ($contents_grouped as $group_name => $contents): ?>
        <div class="accordion-item">
            <button type="button" class="accordion-header">
                <span><i class="fas fa-layer-group"></i> <?php echo "Konten Halaman " . ucwords($group_name); ?></span>
                <i class="fas fa-chevron-down"></i>
            </button>
            <div class="accordion-content">
                <?php foreach($contents as $key => $value): ?>
                <div class="form-group">
                    <label for="<?php echo $key; ?>"><?php echo ucwords(str_replace('_', ' ', $key)); ?>:</label>
                    <textarea name="content[<?php echo $key; ?>]"><?php echo htmlspecialchars($value); ?></textarea>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</form>

<script>
    document.querySelectorAll('.accordion-header').forEach(button => {
        button.addEventListener('click', () => {
            const content = button.nextElementSibling;
            button.classList.toggle('active');
            if (content.style.maxHeight) {
                content.style.maxHeight = null;
                content.style.padding = "0 20px";
            } else {
                content.style.maxHeight = content.scrollHeight + 40 + "px";
                content.style.padding = "20px";
            }
        });
    });
</script>

<?php require_once 'template/footer.php'; ?>