<?php
session_start();
if (isset($_SESSION['admin_loggedin']) && $_SESSION['admin_loggedin'] === true) {
    header("location: dashboard.php");
    exit;
}
$error_message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $servername = "localhost"; $db_username = "root"; $db_password = ""; $dbname = "stress_sirna_db";
    $conn = new mysqli($servername, $db_username, $db_password, $dbname);

    $email = $_POST['email'];
    $password = $_POST['password'];

    // Cari pengguna dengan email yang diberikan DAN memiliki peran 'admin'
    $stmt = $conn->prepare("SELECT id, username, password FROM users WHERE email = ? AND role = 'admin'");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        $admin = $result->fetch_assoc();
        // Verifikasi password
        if (password_verify($password, $admin['password'])) {
            // Jika berhasil, simpan session
            $_SESSION['admin_loggedin'] = true;
            $_SESSION['admin_id'] = $admin['id'];
            $_SESSION['admin_username'] = $admin['username'];
            header("location: dashboard.php");
            exit;
        } else {
            $error_message = "Email atau password salah.";
        }
    } else {
        $error_message = "Akun admin tidak ditemukan.";
    }
    $stmt->close();
    $conn->close();
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - Stress Sirna</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <style>
        body, html { height: 100%; margin: 0; font-family: 'Poppins', sans-serif; display: flex; align-items: center; justify-content: center; background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%); }
        .login-card { background: #fff; padding: 40px; border-radius: 12px; box-shadow: 0 10px 25px rgba(0,0,0,0.1); width: 360px; text-align: center; }
        .login-card h2 { margin: 0 0 10px 0; color: #1e293b; font-weight: 600; }
        .login-card p { color: #64748b; margin-bottom: 30px; }
        .form-group { text-align: left; margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: 500; color: #475569; }
        .form-group input { width: 100%; padding: 12px 15px; border: 1px solid #cbd5e1; border-radius: 8px; box-sizing: border-box; font-size: 1rem; }
        .btn { width: 100%; padding: 14px; background-color: #3b82f6; color: white; border: none; border-radius: 8px; cursor: pointer; font-size: 1rem; font-weight: 500; transition: background-color 0.3s; }
        .btn:hover { background-color: #2563eb; }
        .error { color: #e53e3e; background-color: #fed7d7; padding: 10px; border-radius: 8px; margin-top: 20px; }
    </style>
</head>
<body>
    <div class="login-card">
        <h2>Admin Panel</h2>
        <p>Silakan login untuk melanjutkan.</p>
        <form action="index.php" method="POST">
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" name="email" id="email" required>
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" name="password" id="password" required>
            </div>
            <button type="submit" class="btn">Login</button>
            <?php if(!empty($error_message)) echo '<p class="error">'.$error_message.'</p>'; ?>

 </div>
        </form>
    </div>
</body>
</html>