<?php
$page_title = 'Edit Pertanyaan';
$current_page = 'questions';
require_once 'template/header.php';
$conn = new mysqli("localhost", "root", "", "stress_sirna_db");
$question_id = $_GET['id'] ?? 0;
// Proses UPDATE
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $stmt = $conn->prepare("UPDATE questions SET question_text = ?, question_order = ? WHERE id = ?");
    $stmt->bind_param("sii", $_POST['question_text'], $_POST['question_order'], $_POST['id']);
    $stmt->execute();
    $stmt->close();
    header("location: manage_questions.php");
    exit;
}
// Ambil data untuk ditampilkan di form
$stmt = $conn->prepare("SELECT question_text, question_order FROM questions WHERE id = ?");
$stmt->bind_param("i", $question_id);
$stmt->execute();
$result = $stmt->get_result();
$q = $result->fetch_assoc();
$stmt->close();
?>
<div class="card">
    <div class="card-header">
        <h1>Edit Pertanyaan</h1>
    </div>
    <form action="edit_question.php" method="POST">
        <input type="hidden" name="id" value="<?php echo $question_id; ?>">
        <div style="margin-bottom: 15px;">
            <label for="question_text">Teks Pertanyaan:</label>
            <textarea name="question_text" style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;" rows="4" required><?php echo htmlspecialchars($q['question_text']); ?></textarea>
        </div>
        <div style="margin-bottom: 15px;">
            <label for="question_order">Nomor Urut:</label>
            <input type="number" name="question_order" style="width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 4px;" value="<?php echo $q['question_order']; ?>" required>
        </div>
        <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
        <a href="manage_questions.php" style="margin-left:10px;">Batal</a>
    </form>
</div>
<?php require_once 'template/footer.php'; ?>