<?php
$page_title = 'Dashboard';
$current_page = 'dashboard';
require_once 'template/header.php'; // Panggil template header

// Koneksi ke DB untuk ambil data statistik
$servername = "localhost"; $db_username = "root"; $db_password = ""; $dbname = "stress_sirna_db";
$conn = new mysqli($servername, $db_username, $db_password, $dbname);

// Hitung jumlah pengguna
$total_users = $conn->query("SELECT COUNT(id) as total FROM users")->fetch_assoc()['total'];
// Hitung jumlah pertanyaan
$total_questions = $conn->query("SELECT COUNT(id) as total FROM questions")->fetch_assoc()['total'];
// Hitung jumlah tes yang sudah diisi
$total_tests = $conn->query("SELECT COUNT(id) as total FROM test_history")->fetch_assoc()['total'];
$conn->close();
?>

<style>
    .stat-cards { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; }
    .stat-card { background-color: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); display: flex; align-items: center; }
    .stat-card .icon { font-size: 3em; margin-right: 20px; }
    .stat-card .info h4 { margin: 0; color: #888; text-transform: uppercase; }
    .stat-card .info p { margin: 5px 0 0; font-size: 2em; font-weight: 600; }
    .stat-card.users .icon { color: #007bff; }
    .stat-card.questions .icon { color: #ffc107; }
    .stat-card.tests .icon { color: #28a745; }
</style>

<div class="card">
    <div class="card-header">
        <h1>Selamat Datang, Admin!</h1>
    </div>
    <p>Ini adalah pusat kendali untuk aplikasi Stress Sirna. Dari sini Anda bisa mengelola konten dan melihat statistik aplikasi.</p>
</div>

<div class="stat-cards">
    <div class="stat-card users">
        <div class="icon"><i class="fas fa-users"></i></div>
        <div class="info">
            <h4>Total Pengguna</h4>
            <p><?php echo $total_users; ?></p>
        </div>
    </div>
    <div class="stat-card questions">
        <div class="icon"><i class="fas fa-question-circle"></i></div>
        <div class="info">
            <h4>Total Pertanyaan</h4>
            <p><?php echo $total_questions; ?></p>
        </div>
    </div>
    <div class="stat-card tests">
        <div class="icon"><i class="fas fa-poll"></i></div>
        <div class="info">
            <h4>Total Tes Diisi</h4>
            <p><?php echo $total_tests; ?></p>
        </div>
    </div>
</div>

<?php require_once 'template/footer.php'; // Panggil template footer ?>