<?php
// Tentukan halaman saat ini dan judulnya untuk template
$current_page = 'informasi'; // Kita anggap ini bagian dari menu Informasi
$page_title = 'Cara Mengatasi Burnout - Stress Sirna';

// Panggil template header. Ini akan otomatis memulai session dan menampilkan navbar.
require_once 'template/header.php';

// Ambil konten dari database
$conn = new mysqli("localhost", "root", "", "stress_sirna_db");
$contents_raw = $conn->query("SELECT content_key, content_value FROM site_content WHERE content_group = 'mengatasi'");
$content = [];
while($row = $contents_raw->fetch_assoc()) { $content[$row['content_key']] = $row['content_value']; }
$conn->close();
?>

<style>
    /* CSS khusus untuk halaman ini agar terlihat elegan */
    .tips-list {
        list-style: none;
        padding: 0;
        margin-top: 30px;
    }
    .tips-item {
        display: flex;
        align-items: flex-start;
        gap: 20px;
        margin-bottom: 25px;
    }
    .tips-item .icon {
        font-size: 1.8em;
        color: #28a745; /* Warna hijau untuk ikon */
        flex-shrink: 0;
    }
    .tips-item h3 {
        margin: 0 0 5px 0;
        font-size: 1.2em;
        color: #2c3e50;
    }
    .tips-item p {
        margin: 0;
        color: #555;
    }
</style>

<div class="main-container">
    <div class="card">
        <h1><?php echo $content['mengatasi_title'] ?? 'Cara Mengatasi & Mencegah Burnout'; ?></h1>
        
        <ul class="tips-list">
            <li class="tips-item">
                <span class="icon"><i class="fas fa-search-plus"></i></span>
                <div>
                    <h3><?php echo $content['mengatasi_1_title'] ?? 'Judul Tips 1'; ?></h3>
                    <p><?php echo $content['mengatasi_1_desc'] ?? 'Deskripsi tips 1...'; ?></p>
                </div>
            </li>
            <li class="tips-item">
                <span class="icon"><i class="fas fa-child"></i></span>
                <div>
                    <h3><?php echo $content['mengatasi_2_title'] ?? 'Judul Tips 2'; ?></h3>
                    <p><?php echo $content['mengatasi_2_desc'] ?? 'Deskripsi tips 2...'; ?></p>
                </div>
            </li>
            <li class="tips-item">
                <span class="icon"><i class="fas fa-hand-holding-heart"></i></span>
                <div>
                    <h3><?php echo $content['mengatasi_3_title'] ?? 'Judul Tips 3'; ?></h3>
                    <p><?php echo $content['mengatasi_3_desc'] ?? 'Deskripsi tips 3...'; ?></p>
                </div>
            </li>
            <li class="tips-item">
                <span class="icon"><i class="fas fa-comment-dots"></i></span>
                <div>
                    <h3><?php echo $content['mengatasi_4_title'] ?? 'Judul Tips 4'; ?></h3>
                    <p><?php echo $content['mengatasi_4_desc'] ?? 'Deskripsi tips 4...'; ?></p>
                </div>
            </li>
        </ul>
    </div>
</div>

<?php
// Panggil template footer untuk menutup halaman
require_once 'template/footer.php';
?>